clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-07-22_14-58-58.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);

%% GRAFICI

figure(1)
% durezuibe

subplot(3,1,1)
plot(data1(:,1)-data1(1,1)-30,data1(:,11),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1)-30,data1(:,10),"k", 'LineWidth', 1.5)
hold on
xlabel('time [s]');
ylabel('Heading [deg]');
legend('com','response', 'Location', 'northeast');
xlim([0 95])
grid on
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 600]) % [x, y, width, height]
ylim([110 133])

subplot(3,1,2)
plot(data1(:,1)-data1(1,1)-30,data1(:,8),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('bank [deg]');
xlim([0 95])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z

subplot(3,1,3)
plot(data1(:,1)-data1(1,1)-30,data1(:,14),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('\deltaa [deg]');
xlim([0 95])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
ylim([-13 12])
